unit menu_u;

interface


Type
   MenuType = (Vertical, Horizontal);

{ 롨ࠥ 㦭   ⮩ 㭪樥 }
function MenuOption (optText: array of string; MaxItems, width: integer): byte;

procedure TextWindow (x1, y1, x2, y2: integer; fn: string);

var
   optSelected,  { 梥 뤥 ⮢  }
   optNormal   : integer; { 梥 뤥 ⮢  }
   _style: menuType;  { 뢠  ⨯ : ⨪ (Vertical)
                         ਧ⠫ (Horizontal) }


Implementation
uses crt;

var
   X, Y,
   selected,  {  ,  㤥 ᢥ稢  砫
                ணࠬ }
   row: integer;


{  楤 ᯮ 楤ன MenuOption  ஥  }
procedure MakeMenu (optText: array of string; MaxItems, width: integer);
var
   i, _X: byte;
begin
     Y := row;
     _X := X;
     for i := 0 to MaxItems-1 do
     begin
          GoToXY (_X, Y);
          if i = selected then
             TextColor (optSelected)
          else
             TextColor (optNormal);
          write (optText[i]);

          If _style = Horizontal Then
            inc (_X, width + 1)
          Else
            inc (Y, 2);
     end;
end;

{ 롨ࠥ 㦭   ⮩ 㭪樥 }
function MenuOption (optText: array of string; MaxItems, width: integer): byte;
var
   ch: char;
begin
     selected := 0;

     If _style = Vertical then begin
       X := (80 - width) div 2;
       row := (25 - MaxItems) div 2;
     End
     Else Begin
       X := (80 - MaxItems * width) div 2;
       row := 2; { 窠,  ன 㤥 室 ਧ⠫쭮  }
       GotoXY(1, row); ClrEol; { ...   ਧ⠫쭮 - ⮫쪮 ப
                                  㤥 . }
     End;

     repeat
           MakeMenu (optText, MaxItems, width);
           ch := readkey;
           if ch = #0 then
              ch := readkey;
           case ch of
           #80, #77: {Down/Right}
           begin
                inc (Selected);
                if Selected = MaxItems then
                   Selected := 0;
                MakeMenu (optText, MaxItems, width);
           end;

           #72, #75: {Up/Left}
           begin
                dec (Selected);
                if Selected < 0 then
                   Selected := MaxItems-1;
                MakeMenu (optText, MaxItems, width);
           end;
           end;
     until ch = #13; {Enter}
     MenuOption := Selected + 1;

     TextColor (optNormal);
     If _style = Vertical Then
        clrscr;
end;


procedure LoadText (fname: string);
var F: text;
    str: string;
begin
     Assign (F, fname);
     {$I-}
     Reset (F);
     {$I+}
     if IOresult = 0 then
     while Not EOF (F) do
     begin
          readln (F, str);
          writeln (str);
     end;
     Close (F);
end;

procedure TextWindow (x1, y1, x2, y2: integer; fn: string);
const
     TextColor = Cyan;
begin
     Window (x1, y1, x2, y2);
     TextBackground (TextColor);
     ClrScr;

     LoadText (fn);

     Window (1, 1, 80, 25);
     TextBackground (Black);
end;


begin
     _style := Vertical; { ⨪쭮  }
     optNormal := LightGray;
     optSelected := Yellow;
end.