uses crt;
Type
   MenuType = (Vertical, Horizontal);

const
   width1 = 9; { ᨬ쭠  ⮢ (㪢)  }

   Items1 = 5; { ᨬ쭮 ⢮ ⮢  1 }
   optText1: array [0..Items1-1] of string =
   ('',
    '⠭',
    '',
    '',
    '室');

   width2 = 6; { ᨬ쭠  ⮢ (㪢)  }
   Items2 = 3; { ᨬ쭮 ⢮ ⮢  2 }
   optText2: array [0..Items2-1] of string = (
    'item 1',
    'item 2',
    'item 3'
    );

   optNormal = LightGray; { 梥 뤥 ⮢  }
   optSelected = Yellow;  { 梥 뤥 ⮢  }

var
   X, Y,
   selected,  {  ,  㤥 ᢥ稢  砫
                ணࠬ }
   row: integer;
   _style: menuType;  { 뢠  ⨯ : ⨪ (Vertical)
                         ਧ⠫ (Horizontal) }


{  楤 ᯮ 楤ன MenuOption  ஥  }
procedure MakeMenu (optText: array of string; MaxItems, width: integer);
var
   i, _X: byte;
begin
     Y := row;
     _X := X;
     for i := 0 to MaxItems-1 do
     begin
          GoToXY (_X, Y);
          if i = selected then
             TextColor (optSelected)
          else
             TextColor (optNormal);
          write (optText[i]);

          If _style = Horizontal Then
            inc (_X, width + 1)
          Else
            inc (Y, 2);
     end;
end;

{ 롨ࠥ 㦭   ⮩ 㭪樥 }
function MenuOption (optText: array of string; MaxItems, width: integer): byte;
var
   ch: char;
begin
     selected := 0;

     If _style = Vertical then begin
       X := (80 - width) div 2;
       row := (25 - MaxItems) div 2;
     End
     Else Begin
       X := (80 - MaxItems * width) div 2;
       row := 2; { 窠,  ன 㤥 室 ਧ⠫쭮  }
       GotoXY(1, row); ClrEol; { ...   ਧ⠫쭮 - ⮫쪮 ப
                                  㤥 . }
     End;

     repeat
           MakeMenu (optText, MaxItems, width);
           ch := readkey;
           if ch = #0 then
              ch := readkey;
           case ch of
           #80, #77: {Down/Right}
           begin
                inc (Selected);
                if Selected = MaxItems then
                   Selected := 0;
                MakeMenu (optText, MaxItems, width);
           end;

           #72, #75: {Up/Left}
           begin
                dec (Selected);
                if Selected < 0 then
                   Selected := MaxItems-1;
                MakeMenu (optText, MaxItems, width);
           end;
           end;
     until ch = #13; {Enter}
     MenuOption := Selected + 1;

     TextColor (optNormal);
     If _style = Vertical Then
        clrscr;
end;

procedure Add;
begin
end;

procedure Subtract;
begin
end;

procedure Divide;
begin
end;

procedure Multiply;
begin
end;

procedure LoadText (fname: string);
var F: text;
    str: string;
begin
     Assign (F, fname);
     {$I-}
     Reset (F);
     {$I+}
     if IOresult = 0 then
     while Not EOF (F) do
     begin
          readln (F, str);
          writeln (str);
     end;
     Close (F);
end;

procedure TextWindow (x1, y1, x2, y2: integer; fn: string);
const
     TextColor = Cyan;
begin
     Window (x1, y1, x2, y2);
     TextBackground (TextColor);
     ClrScr;

     LoadText (fn);

     Window (1, 1, 80, 25);
     TextBackground (Black);
end;

var
  Option: byte; {  ࠭ 㭪 }

begin
     clrscr;
     TextWindow (2, 2, 78, 7, 'menu.txt');
     _style := Vertical; { ⨪쭮  }
     Option := MenuOption (optText1, Items1, width1);

     case option of
     1: Add;       { ᫮ ᫠ }
     2: Subtract;  {  ᫠ }
     3: Divide;    {  ᫠ }
     4: Multiply;  { 㬭 ᫠ }
     5: exit;      {   ணࠬ }
     end;

     { 뢥 (᫨ 㦭)  ࠭ 㭪 }
     writeln (' 㭪: ', option);
     readln;

     _style := Horizontal; { ਧ⠫쭮  }
     Option := MenuOption (optText2, Items2, width2);
end.