
  {
    Keywords: OOP, Collection, Database

    ணࠬ     ᭮ 権.
    ᯮ 樨 , ।஢, 㤠, ᬮ, ᪠  樨,
    ࠭  㧪 樨.

    ਬ砭: ணࠬ ᫮   ᯮ짮 䥩 Turbo Vision.

    Romtek (c) May 2005
  }


uses crt, objects, drivers, strings, StudObj;

const
  db_file = 'stud_db.dat';
  maxitems = 9;
  OptionsList: array [1..maxitems] of string[30] = (
    'Load collection from file',
    'Save collection to file',
    'View collection',
    'Add record',
    'Edit record',
    'Delete record',
    'Search record in collection',
    'Best students',
    'Quit from program'
  );

var
  Created,
  Quit: boolean;
  option: integer;



procedure AbortMsg (msg: string);
 { 뢥 ᮮ饭  訡    ணࠬ }
begin
     writeln (msg);
     halt;
end;


procedure LoadCollection;
 { 㧪 ࠭ ࠭ 樨  ୮ 䠩 樨 }
var
  FS: TBufStream;
begin
  FS.Init (db_file, stOpen,1024);
  if FS.Status <> stOK then
     AbortMsg ('File not found.'); {    }
  PC := PStudentsColl (FS.Get); { ⠢   䠩  }
  FS.Done;
  if FS.Status <> stOK then
     AbortMsg ('Error of loading collection.');
	{ ந諠 訡 ⥭ 樨. ஡ ᪠  ࠢ  'stXXX' }

  writeln;
  writeln ('Collection is loaded successfully.');  { 饭  ᯥ譮 㦥 樨 }
  readln;
end;



procedure SaveCollection;
 { ࠭   䠩 }
var
  FS: TBufStream;
begin
  FS.Init (db_file, stCreate,1024); { 뢠 䠩 樨  ᮧ }
  FS.Put (PC); { ⠢塞   䠩 }
  FS.Done; { 뢠 ࠡ  ⮪ }
  if FS.Status <> stOK then
     AbortMsg ('Error while saving collection!'); { ந諠 訡  ࠭ 樨 }

  writeln;
  writeln ('Collection is stored successfully.');  { 饭  ᯥ譮 ࠭ 樨 }
  readln;
end;


procedure ViewCollection (C: PCollection);
procedure CallPrint (P : PStudentInfo); far;
 { 易⥫쭮  ⢮ ४⨢ FAR !
   ஬ ⮣, 楤   ,   ஡. }
begin
  P^.Print;
end;
begin { Print }
  Writeln;
  Writeln;
  Writeln ('Student list:');
 {   ForEach 뢮 ଠ   㤥 }
  C^.ForEach (@CallPrint);
  readln;
end;


procedure PrintMatches (C: PCollection; _Mark: integer);
 {   뢮 㤥⮢,  業  㪠 _Mark }
var count: word;
procedure Match (P : PStudentInfo); far;
begin
     if PStudentInfo(P)^.TransferRecord.Mark >= _Mark then
     begin
          P^.Print;
          inc (count);
     end;
end;

begin { Print }
  count:=0;
  Writeln (#13#10'Students who have mark above ', _Mark,': ');
  C^.ForEach (@Match);
  writeln;
  Writeln ('Total: ', count);
  readln;
end;

procedure BestStudents;
begin
     PrintMatches (PC, 80); { ᪠ 㤥⮢,    80 }
end;


procedure SearchRecord;
var
   P: PStudentInfo;
   i: integer;
   who: string;

 function Matches (Item: Pointer): Boolean; far;
 begin
     Matches := PStudentInfo (Item)^.TransferRecord.Name = Who;
 end;

begin
     write ('Look for student (name): '); readln (who);
     { ᯮ  FirstThat, ⮡   "",
     㤮⢮ ᫮ }
     P := PC^.FirstThat (@Matches);
     i := PC^.IndexOf (P);
     if i >= 0 then
     begin
          writeln ('Student was found:');
          PStudentInfo(PC^.At(i))^.Print;
     end
     else writeln ('"', Who ,'" was not found.');
     readln;
end;

procedure AddRecord;
 {  "窨"    }
var
  SI: PStudentInfo;
  Rec: TRecord;
begin
     writeln('Enter some info about a student: ');

     SI := New (PStudentInfo, Init);  {  "" 㤥 }
     with SI^.TransferRecord do
     begin
          write ('Name: ' : 8); readln (Name); {   䠬 }
          write ('Mark: ' : 8); readln (Mark); {  業 }
     end;
     PC^.Insert (SI);  { ⠢塞   㤥   }

     writeln;
     writeln ('Record stored successfully.'); { 饭  ᯥ譮  "窥" }
     readln;
end;


procedure EditRecord;
 { ஢  "" 㤥 }
var
  SI: PStudentInfo;
  Rec: TRecord;
  num: integer;
begin
     { ० 祬    "窥" 㤥,      樨.
       ⮬  砫 㦭 ᬮ ᯨ᮪ 롮஬ 'View collection' }
     write ('Enter number of student in list: '); readln (num);

     SI := PC^.At (Pred (num)); { ᢠ 㪠⥫  "" 㤥  ஬ num-1.
      뢠,  㬥     ! }
     with SI^.TransferRecord do
     begin
          SI^.Print; { 뢠 ⥪騥   "窨" 㤥 }
          writeln;
          write ('Enter new name: '); readln (Name); {   䠬 }
          write ('Enter new mark: '); readln (Mark); {  業 }
     end;

     writeln;
     writeln ('Record stored successfully.'); { 饭  ᯥ譮  "窥" }
     readln;
end;


procedure DeleteRecord;
 {  "窨"  樨 }
var
  SI: PStudentInfo;
  Rec: TRecord;
  num: integer;
begin
     { ० 祬 㤠   "窥" 㤥,      樨.
       ⮬  砫 㦭 ᬮ ᯨ᮪ 롮஬ 'View collection' }
     write ('Enter number of student in list: '); readln (num);

     PC^.AtDelete (Pred (num));

     writeln;
     writeln ('Record deleted successfully.'); { 饭  ᯥ譮  "窨" }
     readln;
end;


procedure ShowMenu;
 { ஥   롮 樨 }
var
   i: integer;
begin
     clrscr;
     writeln ('-= Menu =-': 46);

     for i := 1 to maxitems do
     begin
          writeln;
          writeln (i: 26, '.  ', OptionsList[i]); { 뢮 ⮢  }
     end;

     writeln;
     writeln;
     write ('Enter option: ': 43); readln (option);
end;


BEGIN
  Created := true;

  PC:=New(PStudentsColl,Init(50,10));
  {  樨    50 ꥪ⮢.
     10   ⮬,  ᫨ ⠥ ⠢    祬 50 ꥪ⮢,
     ⠭ 㢥稢 砫 ࠧ (50)  10,   墠    ꥪ⮢. }
  if PC = Nil then { ,  墠⨫ ... 室. }
     exit;

  repeat
        ShowMenu;
	{ 롮 樨 }
        case option of
          1: if PC^.Count = 0 then {   }
                LoadCollection;
          2: SaveCollection;
          3: ViewCollection (PC);
          4: AddRecord;
          5: EditRecord;
          6: DeleteRecord;
          7: SearchRecord;
          8: BestStudents;
          9: Quit := true; { 稫    ணࠬ }
        end;
  until Quit;

  { ᢮   樨 }
  Dispose(PC, Done);
END.