forth
| loc:
 : npages ( bytes -- pages ) dup <>0 if 1- then 12 >> 1+ ;
 : roundmem npages 12 << ;
 : needpages ( nd ns -- result ) over + npages swap npages > ;
 : checkmem ( ns ad nd -- ad' n+ ) rot 2dup needpages if + tuck roundmem resizemem swap else + then ;
 : checkptr ( ns pdst -- ) tuck p@ checkmem rot p! ;
 : str+ 2dup checkptr p@ + over - swap move ;
 : strinit ( a ns pdst -- ) 4096 getmem over ! str+ ;
| ;loc alias str+ ( a ns pdst -- )

forth
| loc:
 : checkmem ( ns ad nd -- ad' n+ ) rot + tuck resizemem swap ;
 : checkptr ( ns pdst -- ) tuck p@ checkmem rot p! ;
 : str+ 2dup checkptr p@ + over - swap move ;
 : strinit ( a ns pdst -- ) 4096 getmem over ! str+ ;
| ;loc alias str+ ( a ns pdst -- )

forth
| loc:
 : npages ( bytes -- pages ) >0 if 1- then 12 >> 1+ ;
 : roundmem npages 12 << ;
 : needpages ( nd ns -- result ) over + npages swap npages > ;
 : checkmem ( ns ad nd -- ad' n+ ) rot 2dup + -rot needpages if tuck roundmem 2dup . . resizemem dup . swap then ;
 : checkptr ( ns pdst -- ) tuck p@ checkmem rot p! ;
 : str+ dup cell+ @ -rot 2dup checkptr rot ( a ns pdst nd )
    swap @ + swap ." q" move ;
 : strinit 4096 getmem over ! str+ ;
| ;loc alias str+ ( a ns pdst -- )

 from kernel32.dll
  1 import GlobalSize

loc:
 from kernel32.dll
  2 import GlobalAlloc
  3 import GlobalReAlloc
  1 import GlobalFree
 0 const GMEM_FIXED
 :: GMEM_FIXED swap GlobalAlloc ;
 :: swap GMEM_FIXED -rot GlobalReAlloc ;
 :: GlobalFree drop ;
;loc
 alias freemem ( p -- )
 alias resizemem ( p n -- new_p ) | page size = 4k !
 alias getmem ( n -- p ) | page size = 4k !

: getmemforcode ( n -- ) getmem h0 ! ;
: getmemfordictionary ( n -- ) getmem dictionary_top ! ;
: getmemforstack ( n -- ) dup getmem + setstackpointer ;

loc:
 from kernel32.dll
  2 import GlobalAlloc
  3 import GlobalReAlloc
  1 import GlobalFree
  1 import GlobalHandle
  1 import GlobalLock
  1 import GlobalUnlock
 0 const GMEM_FIXED
 2 const GMEM_MOVEABLE
 :: GMEM_FIXED swap GlobalAlloc ;
 :: swap GlobalHandle dup . swap GMEM_MOVEABLE GlobalReAlloc dup . GlobalLock ;
 :: GlobalFree drop ;
;loc
 alias freemem ( p -- )
 alias resizemem ( p n -- new_p ) | page size = 4k !
 alias getmem ( n -- p ) | page size = 4k !

: getmemforcode ( n -- ) getmem h0 ! ;
: getmemfordictionary ( n -- ) getmem dictionary_top ! ;
: getmemforstack ( n -- ) dup getmem + setstackpointer ;

loc:
 from kernel32.dll
  3 import HeapCreate
  1 import HeapDestroy
  3 import HeapAlloc
  3 import HeapFree
  4 import HeapReAlloc
  2 import HeapCompact
 1 const HEAP_NO_SERIALIZE
 4 const HEAP_GENERATE_EXCEPTIONS
 8 const HEAP_ZERO_MEMORY
 var heap
 HEAP_NO_SERIALIZE 0 0 HeapCreate heap !
 : getmem heap @ swap HEAP_NO_SERIALIZE HEAP_ZERO_MEMORY or swap HeapAlloc ;
 : freemem heap @ swap HEAP_NO_SERIALIZE swap HeapFree ;
 : resizemem heap @ -rot HEAP_NO_SERIALIZE HEAP_ZERO_MEMORY or -rot HeapReAlloc ;
 ' getmem ' resizemem ' freemem
;loc
 alias freemem ( p -- )
 alias resizemem ( p n -- new_p ) | page size = 4k !
 alias getmem ( n -- p ) | page size = 4k !

