;
; Virtual Pascal  Version 2.1.243  Copyright (C) 2000 vpascal.com
		.586P
		IFDEF	??VERSION
		LOCALS @@
		ENDIF

CODE32		SEGMENT DWORD USE32 PUBLIC 'CODE'
CODE32		ENDS

CONST32		SEGMENT DWORD USE32 PUBLIC 'CONST'
CONST32		ENDS

DATA32		SEGMENT DWORD USE32 PUBLIC 'DATA'
DATA32		ENDS

TLS		SEGMENT DWORD USE32 PUBLIC 'TLS'
TLS		ENDS

BSS32		SEGMENT DWORD USE32 PUBLIC 'BSS'
BSS32		ENDS

DGROUP		GROUP CONST32, DATA32, TLS, BSS32
		.MODEL FLAT

CODE32		SEGMENT
		ASSUME CS:FLAT, DS:FLAT, SS:FLAT, ES:FLAT



		ALIGN DWORD

Program@reg2pas PROC	NEAR
;
; procedure reg2pas; assembler;
;  asm
;
		PUSH	EBP
		MOV	EBP,ESP
	      @@?0:
		MOV	DWORD PTR Program@forth_eax,EAX
		MOV	DWORD PTR Program@forth_esi,ESI
		MOV	DWORD PTR Program@forth_edi,EDI
		MOV	EBX,DWORD PTR Program@pas_ebx
		MOV	EDI,DWORD PTR Program@pas_edi
		FSTP	TBYTE PTR Program@forth_st0
;
;  end;
;
		POP	EBP
		RET
Program@reg2pas ENDP

		ALIGN DWORD

Program@reg2forth PROC	NEAR
;
; procedure reg2forth; assembler;
;  asm
;
		PUSH	EBP
		MOV	EBP,ESP
	      @@?0:
		MOV	DWORD PTR Program@pas_ebx,EBX
		MOV	DWORD PTR Program@pas_edi,EDI
		MOV	EAX,DWORD PTR Program@forth_eax
		MOV	ESI,DWORD PTR Program@forth_esi
		MOV	EDI,DWORD PTR Program@forth_edi
		FLD	TBYTE PTR Program@forth_st0
;
;  end;
;
		POP	EBP
		RET
Program@reg2forth ENDP

		ALIGN DWORD

Program@dup	PROC	NEAR
;
; procedure dup;
;  begin
;
	      @@?0:
;
;   forth_esi:=forth_esi-4;
;
		MOV	EAX,DWORD PTR Program@forth_esi
		SUB	EAX,4
		MOV	DWORD PTR Program@forth_esi,EAX
;
;   pdword(forth_esi)^:=forth_eax;
;
		MOV	ECX,DWORD PTR Program@forth_esi
		MOV	EAX,DWORD PTR Program@forth_eax
		MOV	[ECX],EAX
;
;  end;
;
		RET
Program@dup	ENDP

		ALIGN DWORD

Program@drop	PROC	NEAR
;
; procedure drop;
;  begin
;
	      @@?0:
;
;   forth_eax:=pdword(forth_esi)^;
;
		MOV	EAX,DWORD PTR Program@forth_esi
		MOV	EAX,[EAX]
		MOV	DWORD PTR Program@forth_eax,EAX
;
;   forth_esi:=forth_esi+4;
;
		MOV	EAX,DWORD PTR Program@forth_esi
		ADD	EAX,4
		MOV	DWORD PTR Program@forth_esi,EAX
;
;  end;
;
		RET
Program@drop	ENDP

		ALIGN DWORD

Program@push	PROC	NEAR
;
; procedure push(value: integer);
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
	      @@?0:
;
;   dup;
;
		CALL	Program@dup
;
;   forth_eax:=value;
;
		MOV	EAX,[EBP+8]
		MOV	DWORD PTR Program@forth_eax,EAX
;
;  end;
;
		POP	EBP
		RET	4
Program@push	ENDP

		ALIGN DWORD

Program@Pop	PROC	NEAR
;
; function Pop: Integer;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,4
	      @@?0:
;
;   pop:=forth_eax;
;
		MOV	EAX,DWORD PTR Program@forth_eax
		MOV	[EBP-4],EAX
;
;   drop;
;
		CALL	Program@drop
;
;  end; 
;
		MOV	EAX,[EBP-4]
		LEAVE
		RET
Program@Pop	ENDP

		ALIGN DWORD

Program@init	PROC	NEAR
;
; procedure init;
;  asm
;
		PUSH	EBP
		MOV	EBP,ESP
	      @@?0:
		CALL	Program@reg2forth
		CALL	Program@retroforth_init
		CALL	Program@reg2pas
;
;  end;
;
		POP	EBP
		RET
Program@init	ENDP

		ALIGN DWORD

Program@Eval_mem PROC	NEAR
;
; procedure Eval_mem(p: pointer; len: integer);
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
	      @@?0:
;
;   push(integer(p));
;
		PUSH	DWORD PTR [EBP+0Ch]
		CALL	Program@push
;
;   push(len);
;
		PUSH	DWORD PTR [EBP+8]
		CALL	Program@push
;
;   asm
;    call reg2forth
;    call retroforth_eval
;    call reg2pas
;   end;
;
		CALL	Program@reg2forth
		CALL	Program@retroforth_eval
		CALL	Program@reg2pas
;
;  end;
;
		POP	EBP
		RET	8
Program@Eval_mem ENDP

		ALIGN DWORD

Program@Eval_string PROC NEAR
;
; procedure Eval_string(const Value: string);
;  var a: pointer;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,4
	      @@?0:
;
;   a:=pointer(integer(@value)+1);
;
		MOV	EAX,[EBP+8]
		LEA	EAX,[EAX+1]
		MOV	[EBP-4],EAX
;
;   eval_mem(a, length(value));
;
		PUSH	DWORD PTR [EBP-4]
		MOV	EAX,[EBP+8]
		MOVZX	EAX,BYTE PTR [EAX]
		PUSH	EAX
		CALL	Program@Eval_mem
;
;  end;
;
		LEAVE
		RET	4
Program@Eval_string ENDP

		ALIGN DWORD

Program@Bind	PROC	NEAR
;
; procedure Bind(const Name: string; Proc: Pointer); //stdcall;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,208h
		PUSH	EBX
		PUSH	ESI
		PUSH	EDI
		PUSH	OFFSET Program@Const@+21h
		PUSH	OFFSET @@?2
		CALL	System@_MemLocInit
	      @@?0:
;
;   eval_string(' : ' + Name + ' [ $' + IntToHex(Integer(Proc), 8) + ' compile ] ;');
;
		LEA	EAX,[EBP-208h]
		PUSH	EAX
		LEA	EAX,[EBP-108h]
		PUSH	EAX
		LEA	EAX,[EBP-100h]
		PUSH	EAX
		PUSH	OFFSET Program@Const@
		CALL	System@_StrLoad
		MOV	EAX,[EBP+0Ch]
		PUSH	EAX
		CALL	System@_StrConcat
		PUSH	OFFSET Program@Const@+4
		CALL	System@_StrConcat
		CALL	System@_LStrStr
		LEA	EAX,[EBP-104h]
		PUSH	EAX
		PUSH	DWORD PTR [EBP+8]
		PUSH	8
		CALL	SysUtils@IntToHex
		POP	EAX
		PUSH	DWORD PTR [EAX]
		CALL	System@_LStrConcat
		PUSH	OFFSET Program@Const@+14h
		CALL	System@_LStrConcat
		POP	EAX
		PUSH	DWORD PTR [EAX]
		PUSH	0FFh
		CALL	System@_LStr2Str
		CALL	Program@Eval_string
;
;  end;
;
		XOR	EAX,EAX
		POP	DWORD PTR FS:[EAX]
		ADD	ESP,8
		PUSH	OFFSET @@?3
	      @@?1:
		PUSH	OFFSET Program@Const@+21h
		CALL	System@_MemLocFin
		RET
	      @@?2:
		JMP	System@_XcptFinally
		JMP	@@?1
	      @@?3:
		POP	EDI
		POP	ESI
		POP	EBX
		LEAVE
		RET	8
Program@Bind	ENDP

		ALIGN DWORD

Program@vectorize PROC	NEAR
;
; procedure vectorize(const Name: string; Proc: Pointer); //stdcall;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,100h
	      @@?0:
;
;   eval_string('32 parse '+name+' find'); //  -   
;
		LEA	EAX,[EBP-100h]
		PUSH	EAX
		PUSH	OFFSET Program@Const@+34h
		CALL	System@_StrLoad
		MOV	EAX,[EBP+0Ch]
		PUSH	EAX
		CALL	System@_StrConcat
		PUSH	OFFSET Program@Const@+40h
		CALL	System@_StrConcat
		CALL	Program@Eval_string
;
;   asm
;    mov eax, [proc]
;    sub eax, [forth_eax]
;    mov edx, [forth_eax]
;    sub eax, 5
;    mov byte ptr [edx], $e8   // call
;    mov [edx+1], eax          // address
;    mov byte ptr [edx+5], $c3 //ret
;    mov esi, [forth_esi] //2drop
;    add esi, 8
;    mov eax, [esi]
;    mov [forth_esi], esi
;    mov [forth_eax], eax
;   end;
;
		MOV	EAX,[EBP+8]
		SUB	EAX,DWORD PTR Program@forth_eax
		MOV	EDX,DWORD PTR Program@forth_eax
		SUB	EAX,5
		MOV	BYTE PTR [EDX],0E8h
		MOV	[EDX+1],EAX
		MOV	BYTE PTR [EDX+5],0C3h
		MOV	ESI,DWORD PTR Program@forth_esi
		ADD	ESI,8
		MOV	EAX,[ESI]
		MOV	DWORD PTR Program@forth_esi,ESI
		MOV	DWORD PTR Program@forth_eax,EAX
;
;  end;
;
		LEAVE
		RET	8
Program@vectorize ENDP

		ALIGN DWORD

Program@pas_emit PROC	NEAR
;
; procedure pas_emit;
;  var a: char;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,4
	      @@?0:
;
;   asm
;    mov a, al
;    lodsd
;    call reg2pas
;   end;
;
		MOV	[EBP-1],AL
		LODSD
		CALL	Program@reg2pas
;
;   write(a);
;
		PUSH	OFFSET System@Output
		MOV	AL,[EBP-1]
		PUSH	EAX
		PUSH	0
		CALL	System@_TxtWChar
		CALL	System@_TxtWEnd
;
;   asm
;    call reg2forth
;   end;
;
		CALL	Program@reg2forth
;
;  end;
;
		LEAVE
		RET
Program@pas_emit ENDP

		ALIGN DWORD

Program@forth_type PROC	NEAR
;
; procedure forth_type;
;  var
;   s: string; i, k: integer; p: pointer;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,10Ch
	      @@?0:
;
;   asm
;    mov dword ptr [i], eax
;    lodsd
;    mov p, eax
;    call reg2pas
;   end;
;
		MOV	[EBP-104h],EAX
		LODSD
		MOV	[EBP-10Ch],EAX
		CALL	Program@reg2pas
;
;   while i>0 do begin
;
	      @@?1:
		CMP	DWORD PTR [EBP-104h],0
		JLE	@@?6
	      @@?2:
;
;    if i<255 then k:=i else k:=255;
;
		CMP	DWORD PTR [EBP-104h],0FFh
		JGE	@@?4
	      @@?3:
		MOV	EAX,[EBP-104h]
		MOV	[EBP-108h],EAX
		JMP	@@?5
	      @@?4:
		MOV	DWORD PTR [EBP-108h],0FFh
	      @@?5:
;
;    i:=i-k;
;
		MOV	EAX,[EBP-104h]
		SUB	EAX,[EBP-108h]
		MOV	[EBP-104h],EAX
;
;    s[0]:=char(k);
;
		MOV	AL,[EBP-108h]
		MOV	[EBP-100h],AL
;
;    Move(p^, s[1], Length(s));
;
		MOV	EAX,[EBP-10Ch]
		PUSH	EAX
		LEA	EAX,[EBP-0FFh]
		PUSH	EAX
		MOVZX	EAX,BYTE PTR [EBP-100h]
		PUSH	EAX
		CALL	System@_MemMove
;
;    p:=pointer(integer(p)+k);
;
		MOV	EAX,[EBP-10Ch]
		ADD	EAX,[EBP-108h]
		MOV	[EBP-10Ch],EAX
;
;    write(s);
;
		PUSH	OFFSET System@Output
		LEA	EAX,[EBP-100h]
		PUSH	EAX
		PUSH	0
		CALL	System@_TxtWStr
		CALL	System@_TxtWEnd
;
;   end;
;
		JMP	@@?1
	      @@?6:
;
;   asm
;    call reg2forth
;    lodsd
;   end;
;
		CALL	Program@reg2forth
		LODSD
;
;  end;
;
		LEAVE
		RET
Program@forth_type ENDP

		ALIGN DWORD

Program@use_file PROC	NEAR
;
; function use_file(filename: string): boolean;
;  var f: file; p: pointer; s: integer;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,25Ch
		PUSH	EBX
		PUSH	ESI
		PUSH	EDI
		PUSH	OFFSET Program@Const@+50h
		CALL	System@_CopyParms
		PUSH	OFFSET Program@Const@+46h
		PUSH	OFFSET @@?5
		CALL	System@_MemLocInit
	      @@?0:
;
;   if fileexists(filename) then begin
;
		LEA	EAX,[EBP-25Ch]
		PUSH	EAX
		LEA	EAX,[EBP-104h]
		PUSH	EAX
		CALL	System@_LStrStr
		POP	EAX
		PUSH	DWORD PTR [EAX]
		CALL	SysUtils@FileExists
		TEST	AL,AL
		JE 	@@?2
	      @@?1:
;
;    assign(f, filename);
;
		LEA	EAX,[EBP-250h]
		PUSH	EAX
		LEA	EAX,[EBP-104h]
		PUSH	EAX
		CALL	System@_FileAssign
;
;    reset(f, 1);
;
		LEA	EAX,[EBP-250h]
		PUSH	EAX
		PUSH	1
		CALL	System@_FileReset
;
;    s:=filesize(f);
;
		LEA	EAX,[EBP-250h]
		PUSH	EAX
		CALL	System@_FileSize
		MOV	[EBP-258h],EAX
;
;    getmem(p, s);
;
		PUSH	DWORD PTR [EBP-258h]
		CALL	System@_MemNew
		MOV	[EBP-254h],EAX
;
;    blockread(f, p^, s);
;
		LEA	EAX,[EBP-250h]
		PUSH	EAX
		MOV	EAX,[EBP-254h]
		PUSH	EAX
		PUSH	DWORD PTR [EBP-258h]
		PUSH	0
		CALL	System@_BlockRead
;
;    close(f);
;
		LEA	EAX,[EBP-250h]
		PUSH	EAX
		CALL	System@_FileClose
;
;    eval_mem(p, s);
;
		PUSH	DWORD PTR [EBP-254h]
		PUSH	DWORD PTR [EBP-258h]
		CALL	Program@Eval_mem
;
;    freemem(p);
;
		PUSH	DWORD PTR [EBP-254h]
		CALL	System@_MemFree
;
;    use_file:=true;
;
		MOV	BYTE PTR [EBP-1],1
;
;   end else use_file:=false;
;
		JMP	@@?3
	      @@?2:
		MOV	BYTE PTR [EBP-1],0
	      @@?3:
;
;  end;
;
		XOR	EAX,EAX
		POP	DWORD PTR FS:[EAX]
		ADD	ESP,8
		PUSH	OFFSET @@?6
	      @@?4:
		PUSH	OFFSET Program@Const@+46h
		CALL	System@_MemLocFin
		RET
	      @@?5:
		JMP	System@_XcptFinally
		JMP	@@?4
	      @@?6:
		MOV	AL,[EBP-1]
		POP	EDI
		POP	ESI
		POP	EBX
		LEAVE
		RET	4
Program@use_file ENDP

		ALIGN DWORD

Program@forth_uses PROC	NEAR
;
; procedure forth_uses;
;  var s: string; p: pointer;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,104h
	      @@?0:
;
;   asm
;    mov byte ptr [s], al
;    lodsd
;    mov p, eax
;    call reg2pas
;   end;
;
		MOV	[EBP-100h],AL
		LODSD
		MOV	[EBP-104h],EAX
		CALL	Program@reg2pas
;
;   Move(p^, s[1], Length(s));
;
		MOV	EAX,[EBP-104h]
		PUSH	EAX
		LEA	EAX,[EBP-0FFh]
		PUSH	EAX
		MOVZX	EAX,BYTE PTR [EBP-100h]
		PUSH	EAX
		CALL	System@_MemMove
;
;   if not use_file(s) then writeln('WARNING!! File "', s, '" not found!!');
;
		LEA	EAX,[EBP-100h]
		PUSH	EAX
		CALL	Program@use_file
		TEST	AL,AL
		JNE	@@?2
	      @@?1:
		PUSH	OFFSET System@Output
		PUSH	OFFSET Program@Const@+60h
		PUSH	0
		CALL	System@_TxtWStr
		LEA	EAX,[EBP-100h]
		PUSH	EAX
		PUSH	0
		CALL	System@_TxtWStr
		PUSH	OFFSET Program@Const@+74h
		PUSH	0
		CALL	System@_TxtWStr
		CALL	System@_TxtWLn
	      @@?2:
;
;   asm
;    call reg2forth
;    lodsd
;   end;
;
		CALL	Program@reg2forth
		LODSD
;
;  end;
;
		LEAVE
		RET
Program@forth_uses ENDP

		ALIGN DWORD

Program@_tofloat PROC	NEAR
;
; function _tofloat(s: string; var v: extended): boolean;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,108h
		PUSH	EBX
		PUSH	ESI
		PUSH	EDI
		PUSH	OFFSET Program@Const@+0B4h
		CALL	System@_CopyParms
		PUSH	OFFSET Program@Const@+0AAh
		PUSH	OFFSET @@?7
		CALL	System@_MemLocInit
	      @@?0:
;
;   _tofloat:=true;
;
		MOV	BYTE PTR [EBP-1],1
;
;   try
;
		XOR	EAX,EAX
		PUSH	EBP
		PUSH	OFFSET @@?1
		PUSH	DWORD PTR FS:[EAX]
		MOV	FS:[EAX],ESP
;
;    v:=strtofloat(s);
;
		LEA	EAX,[EBP-108h]
		PUSH	EAX
		LEA	EAX,[EBP-104h]
		PUSH	EAX
		CALL	System@_LStrStr
		POP	EAX
		PUSH	DWORD PTR [EAX]
		CALL	SysUtils@StrToFloat
		MOV	EAX,[EBP+8]
		FSTP	TBYTE PTR [EAX]
;
;   except
;
		XOR	EAX,EAX
		POP	DWORD PTR FS:[EAX]
		ADD	ESP,8
		JMP	@@?5
	      @@?1:
		JMP	System@_XcptOn
		DD	2
		DD	OFFSET SysUtils@EConvertError@$VMT
		DD	OFFSET @@?2
		DD	0
		DD	OFFSET @@?3
	      @@?2:
;
;    on econverTerror do begin
;
;
;     _tofloat:=false;
;
		MOV	BYTE PTR [EBP-1],0
;
;    end;
;   else
;
		JMP	@@?4
	      @@?3:
;
;    writeln('invalid exception during strtofloat!!');
;
		PUSH	OFFSET System@Output
		PUSH	OFFSET Program@Const@+84h
		PUSH	0
		CALL	System@_TxtWStr
		CALL	System@_TxtWLn
;
;   end;
;
	      @@?4:
		CALL	System@_XcptDone
	      @@?5:
;
;  end;
;
		XOR	EAX,EAX
		POP	DWORD PTR FS:[EAX]
		ADD	ESP,8
		PUSH	OFFSET @@?8
	      @@?6:
		PUSH	OFFSET Program@Const@+0AAh
		CALL	System@_MemLocFin
		RET
	      @@?7:
		JMP	System@_XcptFinally
		JMP	@@?6
	      @@?8:
		MOV	AL,[EBP-1]
		POP	EDI
		POP	ESI
		POP	EBX
		LEAVE
		RET	8
Program@_tofloat ENDP

		ALIGN DWORD

Program@forth_strtofloat PROC NEAR
;
; procedure forth_strtofloat;
;  var v: extended; p: pointer; s: string;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,110h
	      @@?0:
;
;   asm
;    mov byte ptr [s], al
;    lodsd
;    mov p, eax
;    lodsd
;    call reg2pas
;   end;
;
		MOV	[EBP-110h],AL
		LODSD
		MOV	[EBP-10h],EAX
		LODSD
		CALL	Program@reg2pas
;
;   Move(p^, s[1], Length(s));
;
		MOV	EAX,[EBP-10h]
		PUSH	EAX
		LEA	EAX,[EBP-10Fh]
		PUSH	EAX
		MOVZX	EAX,BYTE PTR [EBP-110h]
		PUSH	EAX
		CALL	System@_MemMove
;
;   if _tofloat(s, v) then begin
;
		LEA	EAX,[EBP-110h]
		PUSH	EAX
		LEA	EAX,[EBP-0Ch]
		PUSH	EAX
		CALL	Program@_tofloat
		TEST	AL,AL
		JE 	@@?2
	      @@?1:
;
;    push(-1);
;
		PUSH	-1
		CALL	Program@push
;
;    asm
;     call reg2forth
;     fstp st(0)
;     fld tbyte [v]
;     //clc
;    end;
;
		CALL	Program@reg2forth
		FSTP	ST(0)
		FLD	TBYTE PTR [EBP-0Ch]
;
;   end else begin
;
		JMP	@@?3
	      @@?2:
;
;    push(0);
;
		PUSH	0
		CALL	Program@push
;
;    asm
;     call reg2forth
;     //stc
;    end;
;
		CALL	Program@reg2forth
;
;   end;
;
	      @@?3:
;
;  end;
;
		LEAVE
		RET
Program@forth_strtofloat ENDP

		ALIGN DWORD

Program@_tostr	PROC	NEAR
;
; function _tostr(v: extended): string;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,104h
		PUSH	EBX
		PUSH	ESI
		PUSH	EDI
		PUSH	OFFSET Program@Const@+0C1h
		PUSH	OFFSET @@?2
		CALL	System@_MemLocInit
	      @@?0:
;
;   _tostr:=floattostr(v);
;
		LEA	EAX,[EBP-104h]
		PUSH	EAX
		LEA	EAX,[EBP-4]
		PUSH	EAX
		MOV	AX,[EBP+10h]
		PUSH	EAX
		PUSH	DWORD PTR [EBP+0Ch]
		PUSH	DWORD PTR [EBP+8]
		CALL	SysUtils@FloatToStr
		POP	EAX
		PUSH	DWORD PTR [EAX]
		PUSH	0FFh
		CALL	System@_LStr2Str
		MOV	EAX,[EBP+14h]
		PUSH	EAX
		PUSH	0FFh
		CALL	System@_StrStore
;
;  end;
;
		XOR	EAX,EAX
		POP	DWORD PTR FS:[EAX]
		ADD	ESP,8
		PUSH	OFFSET @@?3
	      @@?1:
		PUSH	OFFSET Program@Const@+0C1h
		CALL	System@_MemLocFin
		RET
	      @@?2:
		JMP	System@_XcptFinally
		JMP	@@?1
	      @@?3:
		POP	EDI
		POP	ESI
		POP	EBX
		LEAVE
		RET	0Ch
Program@_tostr	ENDP

		ALIGN DWORD

Program@forth_floattostr PROC NEAR
;
; procedure forth_floattostr;
;  var s: string; v: extended; a, n: integer;
;  begin
;
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,214h
	      @@?0:
;
;   asm
;    fld st(0)
;    fstp tbyte [v]
;    call reg2pas
;   end;
;
		FLD	ST(0)
		FSTP	TBYTE PTR [EBP-10Ch]
		CALL	Program@reg2pas
;
;   s:=_tostr(v);
;   //writeln(s);
;   //push(integer(@s)+1);
;   //push(integer(byte(s[0])));
;
		LEA	EAX,[EBP-214h]
		PUSH	EAX
		MOV	AX,[EBP-104h]
		PUSH	EAX
		PUSH	DWORD PTR [EBP-108h]
		PUSH	DWORD PTR [EBP-10Ch]
		CALL	Program@_tostr
		LEA	EAX,[EBP-100h]
		PUSH	EAX
		PUSH	0FFh
		CALL	System@_StrStore
;
;   a:=integer(@s)+1;
;
		LEA	EAX,[EBP-0FFh]
		MOV	[EBP-110h],EAX
;
;   n:=integer(byte(s[0]));
;
		MOVZX	EAX,BYTE PTR [EBP-100h]
		MOV	[EBP-114h],EAX
;
;   asm
;    call reg2forth
;    sub esi, 4
;    mov [esi], eax
;    mov eax, [a]
;    sub esi, 4
;    mov [esi], eax
;    mov eax, [n]
;   end;
;   //writeln(s, ' ', a, ' ', n);
;
		CALL	Program@reg2forth
		SUB	ESI,4
		MOV	[ESI],EAX
		MOV	EAX,[EBP-110h]
		SUB	ESI,4
		MOV	[ESI],EAX
		MOV	EAX,[EBP-114h]
;
;  end;
;
		LEAVE
		RET
Program@forth_floattostr ENDP

		ALIGN DWORD

Program@$Init	PROC	NEAR
	      @@?0:
;
; begin
;
		MOV	ECX,OFFSET Program@Const@+164h
		MOV	EAX,8000h
		CALL	System@_InitExe
		CALL	System@$Init
		CALL	VpKbdW32@$Init
		CALL	SysUtils@$Init
		PUSH	EBP
		MOV	EBP,ESP
		SUB	ESP,108h
		PUSH	OFFSET Program@Const@+19Ch
		PUSH	OFFSET @@?5
		CALL	System@_MemLocInit
;
;  init;
;
		CALL	Program@init
;
;  eval_string('forth');
;
		PUSH	OFFSET Program@Const@+0CCh
		CALL	Program@Eval_string
;
;  vectorize('emit', @pas_emit);
;
		PUSH	OFFSET Program@Const@+0D4h
		PUSH	OFFSET Program@pas_emit
		CALL	Program@vectorize
;
;  vectorize('type', @forth_type);
;
		PUSH	OFFSET Program@Const@+0DCh
		PUSH	OFFSET Program@forth_type
		CALL	Program@vectorize
;
;  bind('(strtofloat)', @forth_strtofloat);
;
		PUSH	OFFSET Program@Const@+0E4h
		PUSH	OFFSET Program@forth_strtofloat
		CALL	Program@Bind
;
;  bind('(floattostr)', @forth_floattostr);
;
		PUSH	OFFSET Program@Const@+0F4h
		PUSH	OFFSET Program@forth_floattostr
		CALL	Program@Bind
;
;  bind('uses', @forth_uses);
;
		PUSH	OFFSET Program@Const@+104h
		PUSH	OFFSET Program@forth_uses
		CALL	Program@Bind
;
;  decimalseparator:='.';
;
		MOV	BYTE PTR SysUtils@DecimalSeparator,2Eh
;
;  eval_string(': decimalseparator $'+inttohex(integer(@decimalseparator), 8)+' ;');
;
		LEA	EAX,[EBP-108h]
		PUSH	EAX
		LEA	EAX,[EBP-8]
		PUSH	EAX
		PUSH	OFFSET Program@Const@+114h
		CALL	System@_LStrLoad
		LEA	EAX,[EBP-4]
		PUSH	EAX
		PUSH	OFFSET SysUtils@DecimalSeparator
		PUSH	8
		CALL	SysUtils@IntToHex
		POP	EAX
		PUSH	DWORD PTR [EAX]
		CALL	System@_LStrConcat
		PUSH	OFFSET Program@Const@+134h
		CALL	System@_LStrConcat
		POP	EAX
		PUSH	DWORD PTR [EAX]
		PUSH	0FFh
		CALL	System@_LStr2Str
		CALL	Program@Eval_string
;
;  eval_string(': uses" ''" parse uses ;');
;
		PUSH	OFFSET Program@Const@+138h
		CALL	Program@Eval_string
;
;  eval_string('uses" system.f"');
;
		PUSH	OFFSET Program@Const@+150h
		CALL	Program@Eval_string
;
;  s:='';
;
		MOV	BYTE PTR Program@s,0
;
;  while s<>'bye' do begin
;
	      @@?1:
		PUSH	OFFSET Program@s
		PUSH	OFFSET Program@Const@+160h
		CALL	System@_StrCmp
		JE 	@@?3
	      @@?2:
;
;   eval_string(s);
;
		PUSH	OFFSET Program@s
		CALL	Program@Eval_string
;
;   readln(s);
;
		PUSH	OFFSET System@Input
		PUSH	OFFSET Program@s
		PUSH	0FFh
		CALL	System@_TxtRStr
		CALL	System@_TxtRLn
;
;  end;
;
		JMP	@@?1
	      @@?3:
;
; end.
;
		XOR	EAX,EAX
		POP	DWORD PTR FS:[EAX]
		ADD	ESP,8
		PUSH	OFFSET @@?6
	      @@?4:
		PUSH	OFFSET Program@Const@+19Ch
		CALL	System@_MemLocFin
		RET
	      @@?5:
		JMP	System@_XcptFinally
		JMP	@@?4
	      @@?6:
		LEAVE
		PUSH	0
		CALL	System@_Halt
Program@$Init	ENDP

; EXTERNALS
		EXTRN	System@_BlockRead:PROC







































CODE32		ENDS

CONST32			SEGMENT
Program@Const@		EQU	$
			DB	 03h, 20h, 3Ah, 20h, 04h, 20h, 5Bh, 20h	;'. : . [ '
			DB	 24h, 00h, 00h, 00h,0FFh,0FFh,0FFh,0FFh	;'$.......'
			DB	 0Ch, 00h, 00h, 00h, 20h, 63h, 6Fh, 6Dh	;'.... com'
			DB	 70h, 69h, 6Ch, 65h, 20h, 5Dh, 20h, 3Bh	;'pile ] ;'
			DB	 00h, 02h,0F8h,0FEh,0FFh,0FFh	;'......'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 02h,0FCh,0FEh,0FFh,0FFh	;'.....'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 00h, 09h, 33h, 32h, 20h, 70h, 61h, 72h	;'..32 par'
			DB	 73h, 65h, 20h, 00h, 00h, 05h, 20h, 66h	;'se ... f'
			DB	 69h, 6Eh, 64h, 02h,0A4h,0FDh,0FFh,0FFh	;'ind.....'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 00h, 01h, 00h, 08h, 00h,0FCh,0FEh,0FFh	;'........'
			DB	0FFh, 00h, 01h, 00h, 00h, 00h, 00h, 00h	;'........'
			DB	 00h, 10h, 57h, 41h, 52h, 4Eh, 49h, 4Eh	;'..WARNIN'
			DB	 47h, 21h, 21h, 20h, 46h, 69h, 6Ch, 65h	;'G!! File'
			DB	 20h, 22h, 00h, 00h, 00h, 0Dh, 22h, 20h	;' "...." '
			DB	 6Eh, 6Fh, 74h, 20h, 66h, 6Fh, 75h, 6Eh	;'not foun'
			DB	 64h, 21h, 21h, 00h, 00h, 25h, 69h, 6Eh	;'d!!..%in'
			DB	 76h, 61h, 6Ch, 69h, 64h, 20h, 65h, 78h	;'valid ex'
			DB	 63h, 65h, 70h, 74h, 69h, 6Fh, 6Eh, 20h	;'ception '
			DB	 64h, 75h, 72h, 69h, 6Eh, 67h, 20h, 73h	;'during s'
			DB	 74h, 72h, 74h, 6Fh, 66h, 6Ch, 6Fh, 61h	;'trtofloa'
			DB	 74h, 21h, 21h, 02h,0F8h,0FEh,0FFh,0FFh	;'t!!.....'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 00h, 01h, 00h, 0Ch, 00h,0FCh,0FEh,0FFh	;'........'
			DB	0FFh, 00h, 01h, 00h, 00h, 00h, 02h,0FCh	;'........'
			DB	0FFh,0FFh,0FFh	;'...'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 00h, 00h, 05h, 66h, 6Fh, 72h, 74h, 68h	;'...forth'
			DB	 00h, 00h, 04h, 65h, 6Dh, 69h, 74h, 00h	;'...emit.'
			DB	 00h, 00h, 04h, 74h, 79h, 70h, 65h, 00h	;'...type.'
			DB	 00h, 00h, 0Ch, 28h, 73h, 74h, 72h, 74h	;'...(strt'
			DB	 6Fh, 66h, 6Ch, 6Fh, 61h, 74h, 29h, 00h	;'ofloat).'
			DB	 00h, 00h, 0Ch, 28h, 66h, 6Ch, 6Fh, 61h	;'...(floa'
			DB	 74h, 74h, 6Fh, 73h, 74h, 72h, 29h, 00h	;'ttostr).'
			DB	 00h, 00h, 04h, 75h, 73h, 65h, 73h, 00h	;'...uses.'
			DB	 00h, 00h,0FFh,0FFh,0FFh,0FFh, 14h, 00h	;'........'
			DB	 00h, 00h, 3Ah, 20h, 64h, 65h, 63h, 69h	;'..: deci'
			DB	 6Dh, 61h, 6Ch, 73h, 65h, 70h, 61h, 72h	;'malsepar'
			DB	 61h, 74h, 6Fh, 72h, 20h, 24h, 00h, 00h	;'ator $..'
			DB	 00h, 00h,0FFh,0FFh,0FFh,0FFh, 02h, 00h	;'........'
			DB	 00h, 00h, 20h, 3Bh, 00h, 00h, 17h, 3Ah	;'.. ;...:'
			DB	 20h, 75h, 73h, 65h, 73h, 22h, 20h, 27h	;' uses" ''
			DB	 22h, 20h, 70h, 61h, 72h, 73h, 65h, 20h	;'" parse '
			DB	 75h, 73h, 65h, 73h, 20h, 3Bh, 0Fh, 75h	;'uses ;.u'
			DB	 73h, 65h, 73h, 22h, 20h, 73h, 79h, 73h	;'ses" sys'
			DB	 74h, 65h, 6Dh, 2Eh, 66h, 22h, 03h, 62h	;'tem.f".b'
			DB	 79h, 65h	;'ye'
			DD	OFFSET Program@Tls@
			DD	OFFSET Program@Bss@
			DD	OFFSET Program@Code@
			DB	0FFh,0FFh,0FFh,0FFh, 56h, 50h, 55h, 4Dh	;'....VPUM'
			DB	 20h, 00h, 00h, 00h	;' ...'
			DD	OFFSET Program@Code@
			DD	OFFSET Program@Const@
			DD	OFFSET Program@Data@
			DD	OFFSET Program@Tls@
			DD	OFFSET Program@Bss@
			DD	OFFSET System@ExitCode
			DD	OFFSET System@InOutRes
			DD	OFFSET System@Input
			DB	 02h,0F8h,0FFh,0FFh,0FFh	;'.....'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 02h,0FCh,0FFh,0FFh,0FFh	;'.....'
			DD	OFFSET System@AnsiString@$RTTI
			DB	 00h	;'.'

; EXTERNALS
		EXTRN	System@AnsiString@$RTTI:BYTE


CONST32			ENDS

DATA32			SEGMENT
Program@Data@		EQU	$
; EXTERNALS
		EXTRN	System@ExitCode:BYTE

DATA32			ENDS

TLS			SEGMENT
Program@Tls@		EQU	$
; EXTERNALS
		EXTRN	System@InOutRes:BYTE

TLS			ENDS

BSS32			SEGMENT
Program@Bss@		EQU	$
Program@forth_eax	DB	4 DUP(?)
Program@forth_esi	DB	4 DUP(?)
Program@forth_edi	DB	4 DUP(?)
Program@pas_ebx		DB	4 DUP(?)
Program@pas_edi		DB	4 DUP(?)
Program@s		DB	256 DUP(?)
Program@forth_st0	DB	10 DUP(?)

; EXTERNALS
		EXTRN	System@Input:BYTE



BSS32			ENDS

STACK32			SEGMENT DWORD USE32 STACK 'STACK'
			DB	32768 DUP(?)
STACK32			ENDS


; PUBLICS
		PUBLIC	Program@$Init
		PUBLIC	Program@reg2pas
		PUBLIC	Program@pas_edi
		PUBLIC	Program@forth_st0
		PUBLIC	Program@s
		PUBLIC	Program@Eval_string
		PUBLIC	Program@forth_uses
		PUBLIC	Program@Bind
		PUBLIC	Program@forth_type
		PUBLIC	Program@pas_ebx
		PUBLIC	Program@Eval_mem
		PUBLIC	Program@forth_floattostr
		PUBLIC	Program@forth_strtofloat
		PUBLIC	Program@use_file
		PUBLIC	Program@dup
		PUBLIC	Program@pas_emit
		PUBLIC	Program@reg2forth
		PUBLIC	Program@forth_edi
		PUBLIC	Program@Pop
		PUBLIC	Program@_tofloat
		PUBLIC	Program@init
		PUBLIC	Program@drop
		PUBLIC	Program@vectorize
		PUBLIC	Program@_tostr
		PUBLIC	Program@forth_eax
		PUBLIC	Program@forth_esi
		PUBLIC	Program@push
		PUBLIC	Program@Code@
		PUBLIC	Program@Const@
		PUBLIC	Program@Data@
		PUBLIC	Program@Tls@
		PUBLIC	Program@Bss@

		END	Program@$Init
