 uses sysutils;
 
 type pdword = ^integer;
 
 var
  forth_eax, forth_esi, forth_edi, pas_ebx, pas_edi: integer;
  s: string;
  forth_st0: extended;

 procedure retroforth_eval; external 'rf.dll' name 'retroforth_eval';
 procedure retroforth_init; external 'rf.dll' name 'retroforth_init';

procedure reg2pas; assembler;
 asm
  mov [forth_eax], eax
  mov [forth_esi], esi
  mov [forth_edi], edi
  mov ebx, [pas_ebx]
  mov edi, [pas_edi]
  fstp tbyte ptr [forth_st0]
 end;

procedure reg2forth; assembler;
 asm
  mov [pas_ebx], ebx
  mov [pas_edi], edi
  mov eax, [forth_eax]
  mov esi, [forth_esi]
  mov edi, [forth_edi]
  fld tbyte ptr [forth_st0]
 end;

procedure dup;
 begin
  forth_esi:=forth_esi-4;
  pdword(forth_esi)^:=forth_eax;
 end;

procedure drop;
 begin
  forth_eax:=pdword(forth_esi)^;
  forth_esi:=forth_esi+4;
 end;

procedure push(value: integer);
 begin
  dup;
  forth_eax:=value;
 end;

function Pop: Integer;
 begin
  pop:=forth_eax;
  drop;
 end; 

procedure init;
 asm
  call reg2forth
  call retroforth_init
  call reg2pas
 end;

procedure Eval_mem(p: pointer; len: integer);
 begin
  push(integer(p));
  push(len);
  asm
   call reg2forth
   call retroforth_eval
   call reg2pas
  end;
 end;

procedure Eval_string(const Value: string);
 var a: pointer;
 begin
  a:=pointer(integer(@value)+1);
  eval_mem(a, length(value));
 end;

procedure Bind(const Name: string; Proc: Pointer); //stdcall;
 begin
  eval_string(' : ' + Name + ' [ $' + IntToHex(Integer(Proc), 8) + ' compile ] ;');
 end;

procedure vectorize(const Name: string; Proc: Pointer); //stdcall;
 begin
  eval_string('32 parse '+name+' find'); //  -   
  asm
   mov eax, [proc]
   sub eax, [forth_eax]
   mov edx, [forth_eax]
   sub eax, 5
   mov byte ptr [edx], $e8   // call
   mov [edx+1], eax          // address
   mov byte ptr [edx+5], $c3 //ret
   mov esi, [forth_esi] //2drop
   add esi, 8
   mov eax, [esi]
   mov [forth_esi], esi
   mov [forth_eax], eax
  end;
 end;

procedure pas_emit;
 var a: char;
 begin
  asm
   mov a, al
   lodsd
   call reg2pas
  end;
  write(a);
  asm
   call reg2forth
  end;
 end;

procedure forth_type;
 var
  s: string; i, k: integer; p: pointer;
 begin
  asm
   mov dword ptr [i], eax
   lodsd
   mov p, eax
   call reg2pas
  end;
  while i>0 do begin
   if i<255 then k:=i else k:=255;
   i:=i-k;
   s[0]:=char(k);
   Move(p^, s[1], Length(s));
   p:=pointer(integer(p)+k);
   write(s);
  end;
  asm
   call reg2forth
   lodsd
  end;
 end;

function use_file(filename: string): boolean;
 var f: file; p: pointer; s: integer;
 begin
  if fileexists(filename) then begin
   assign(f, filename);
   reset(f, 1);
   s:=filesize(f);
   getmem(p, s);
   blockread(f, p^, s);
   close(f);
   eval_mem(p, s);
   freemem(p);
   use_file:=true;
  end else use_file:=false;
 end;

procedure forth_uses;
 var s: string; p: pointer;
 begin
  asm
   mov byte ptr [s], al
   lodsd
   mov p, eax
   add esi, 4
   call reg2pas
  end;
  Move(p^, s[1], Length(s));
  if not use_file(s) then writeln('WARNING!! File "', s, '" not found!!');
  asm
   call reg2forth
  end;
 end;

function _tofloat(s: string; var v: extended): boolean;
 begin
  _tofloat:=true;
  try
   v:=strtofloat(s);
  except
   on econverTerror do begin
    _tofloat:=false;
   end;
  else
   writeln('invalid exception during strtofloat!!');
  end;
 end;

procedure forth_strtofloat;
 var v: extended; p: pointer; s: string;
 begin
  asm
   call reg2pas
   mov byte ptr [s], al
   lodsd
   mov p, eax
  end;
  Move(p^, s[1], Length(s));
  if _tofloat(s, v) then begin
   push(-1);
   asm
    call reg2forth
    fstp st(0)
    fld tbyte [v]
   end;
  end else begin
   push(0);
   asm
    call reg2forth
   end;
  end;
 end;

function _tostr(v: extended): string;
 begin
  _tostr:=floattostr(v);
 end;

procedure forth_floattostr;
 var s: string; v: extended; a, n: integer;
 begin
  asm
   fld st(0)
   fstp tbyte [v]
   call reg2pas
  end;
  s:=_tostr(v);
  a:=integer(@s)+1;
  n:=integer(byte(s[0]));
  asm
   call reg2forth
   sub esi, 4
   mov [esi], eax
   mov eax, [a]
   sub esi, 4
   mov [esi], eax
   mov eax, [n]
  end;
 end;

begin
 init;
 eval_string('forth');
 vectorize('emit', @pas_emit);
 vectorize('type', @forth_type);
 bind('(strtofloat)', @forth_strtofloat);
 bind('(floattostr)', @forth_floattostr);
 bind('uses', @forth_uses);
 decimalseparator:='.';
 eval_string(': decimalseparator $'+inttohex(integer(@decimalseparator), 8)+' ;');
 eval_string(': uses" ''" parse uses ;');
 eval_string('uses" system.f"');
 s:='';
 while s<>'bye' do begin
  eval_string(s);
  readln(s);
 end;
end.
