| strings and arrays functions for QuickForth; uses windows.f

forth
: array create allot ;
: pointer 2 cells create allot ;

: move ( src dst n -- ) [ $57 1, $56 1, $c189 2, $02e9c1 3, $3e8b 2, $04768b 3, $a5f3 2,
       $c189 2, $03e183 3, $a4f3 2, $5e 1, $5f 1, $08468b 3, $0cc683 3, ] ;
| push edi; push esi; mov ecx, eax; shr ecx, 2; mov edi, [esi]; mov esi, [esi+4]; rep movsd
| mov ecx, eax; and ecx, 3; rep movsb; pop esi; pop edi; mov eax, [esi+8]; add esi, 12
: fill ( dst n byte -- ) [ $57 1, $c289 2, $08e2c1 3, $d009 2, $08e2c1 3, $d009 2, $08e2c1 3, $d009 2,  $0e8b 2, $047e8b 3,
       $ca89 2, $02e9c1 3, $abf3 2, $03e283 3, $d189 2, $aaf3 2, $5f 1, $08468b 3, $0cc683 3, ] ;
| push edi; mov edx, eax; shl edx, 8; or eax, edx; shl edx, 8; or eax, edx; shl edx, 8; or eax, edx; mov ecx, [esi];
| mov edi, [esi+4]; mov edx, ecx; shr ecx, 2; rep stosd; and edx, 3; mov ecx, edx; rep stosb; pop edi; mov eax, [esi+8]; add esi, 12;
: place ( src n dst -- dst ) dup >r swap move r> ;
| : pad here 1024 + ;
create pad 1024 allot
: >pad ( a n -- a' n ) dup 0; >r pad place r> ;

: " '" parse >pad ;

loc:
  : .string dup r> + dup >r over - swap ;
 :: dup literal, dup >r here 5 + place drop c: .string r> allot ;
;loc alias $,

macro
: s" " $, ;
: { '} parse $, c: eval ;

self
: ." state @ if " $, c: type ;then " type ;

forth
: space vector 32 emit ;
: cr vector 10 emit ;
: . vector dup 0 <if '- emit negate then : u. vector # space ;

loc:
  var size
  : make dup -rot here place swap dup allot 0 1, 1+ size +! ;
  : free size @ negate allot 0 size ! ;
  :: make later free ;
;loc alias zt

uses" windows.f" | windows-dependent functions

loc:
  : list 0 last repeat @ 0; dup 13 + dup 1- c@ type space swap 1+ swap again ;
 :: list cr . ." words defined" cr ;
;loc alias words

: hex 16 base ! ;
: decimal 10 base ! ;
: binary 2 base ! ;
: octal 8 base ! ;

: .s 10 for r@ 1- [ $86048b 3, ] . next cr ; | mov eax, [esi+eax*4] ?

macro
: str= $57 1, $56 1, $c189 2, $c031 2, $044e3b 3, $0b75 2, $3e8b 2,
  $08768b 3, $a6f3 2, $0275 2, $d0f7 2, $5e 1, $5f 1, $0cc683 3, ; fast
| push edi; push esi; mov ecx, eax; xor eax, eax; cmp ecx, [esi+4]; jne a; mov edi, [esi];
| mov esi, [esi+8]; repe cmpsb; jne a; not eax; a: pop esi; pop edi; add esi, 12;

forth
: strtoint ( a n -- int ) >number ?if else 2drop 0 then ;

| : strpos ( string substring -- pos ) ;
loc:
 16 8 * array strstack
 -1 var str_n
 : str str_n @ 8 * strstack + ;
 : min ( a b -- min ) 2dup > if nip else drop then ; | !!
 : advance ( n -- ) str cell+ @ min dup str p@ rot - -rot + swap str p! ;
 : beginparse ( a n -- ) str_n dup @ 1+ swap ! str p! ;
 : endparse str_n dup @ 1- swap ! ;
 : getchars ( n -- a n ) str p@ rot min dup advance ;
 | macro
| : findchar ( a n char -- n2 n1 ) [ $57 1, $0e8b 2, $047e8b 3, $aef2 2, $ca89 2, $aef3 2,
|   $068b 2, $c829 2, ] 1- [ $044689 3, $068b 2, $d029 2, ] 1- [ $04c683 3, $5f 1, ] ;
   | push edi; mov ecx, [esi]; mov edi, [esi+4]; repne scasb; mov edx, ecx; repe scasb;
   | mov eax, [esi]; sub eax, ecx; mov [esi+4], eax; mov eax, [esi]; sub eax, edx; add esi, 4; pop edi
   
 : find_char ( a n char -- pos ) [ $57 1, $0e8b 2, $41 1, $047e8b 3, $aef2 2, $068b 2, $c829 2, $5f 1, $08c683 3, ] ;
   | push edi; mov ecx, [esi]; inc ecx; mov edi, [esi+4]; repne scasb; mov eax, [esi]; sub eax, ecx; pop edi; add esi, 8
 : findchar find_char dup 1+ swap ;
 
 forth
 : eolnpos ( -- n2 n1 ) str p@ 10 findchar 1- dup <0 if 1+ else dup str @ + c@ 13 <> if 1+ then then ;
 : isspace ( char -- result ) 32 <= if true else false then ;
 : strparse ( char -- a n ) str p@ rot findchar str @ swap rot advance ;
 : parsespaces ( -- a n ) str p@ repeat 2dup >0 swap c@ isspace and if 1- swap 1+ swap false else 2dup str p! true then until ;
 : parseletters ( -- a n ) str p@ repeat 2dup >0 swap c@ isspace not and if 1- swap 1+ swap false else 2dup str p! true then until ;
 : strwsparse ( -- a n ) parsespaces parseletters nip - ;
 : strlnparse ( -- a n ) str @ eolnpos swap advance ;
 : endofstring str cell+ @ =0 ;
 ' beginparse ' endparse ' getchars ' strparse ' strwsparse ' strlnparse ' endofstring
;loc alias endofstring alias strlnparse alias strwsparse alias strparse alias getchars alias endparse alias beginparse

forth
loc:
 : addmem ( ns ad nd -- ad' n+ ) rot + tuck resizemem swap ;
 : addptr ( ns pdst -- ) tuck p@ addmem rot p! ;
 : setmem ( ad nd -- ad' nd ) tuck resizemem swap ;
 : setptr ( ns pdst -- ) tuck @ swap setmem rot p! ;
 : str+ 2dup addptr p@ + over - swap move ;
 : strmove ( a ns pdst -- ) @ swap move ;
 : str! ( a ns pdst -- ) 2dup setptr strmove ;
 : ptrinit ( pdst n -- ) dup getmem swap rot p! ;
 : strinit ( a ns pdst -- ) 2dup swap ptrinit strmove ;
 ' strinit ' str+ ' str!
;loc alias str! ( a ns pdst -- ) alias str+ ( a ns pdst -- ) alias strinit ( a ns pdst -- )
 
: newstring here pointer 0 0 rot strinit ; | " string" newstring string
: newarray ( n p -- ) over getmem -rot p! ;
: freearray ( p -- ) dup @ freemem 0 0 rot p! ;

| n-dimensional arrays

loc:
 forth
 : literal,, ( l -- ) literal, c: literal ; | 2nd generation literal!!
 : addstring ( ad nd as ns -- a n' ) >r >r >pad 2dup + r> r@ rot swap move r> + ;
 : forthentry ( a n -- ) entry as .forth ;
 : macroentry ( a n -- ) entry as .macro ;
 : constentry ( c a n a n -- ) addstring entry as .data last @ cell+ ! ;
 : addentry ( ad nd as ns -- ) addstring macroentry ;
 : add[] ( a n -- ) s" []" addentry ;
 : add+ ( a n -- ) s" +" addentry ;
 : add- ( a n -- ) s" -" addentry ;
 : compilecell ( cell a n -- a n ) s" cell" constentry ;
 : compilesize ( size a n -- a n ) s" size" constentry ;
 : compile+ ( size a n -- ) add+ literal,, mc: + m: ;; fast ;
 : compile- ( size a n -- ) add- literal,, mc: - m: ;; fast ;
 : compile[] ( nk . . n0 k a n -- memsize ; ; ik-1 . . i0 a -- a ) add[]
   for dup mc: swap literal,, mc: * mc: + * next m: ;; fast ;
 : compilearray ( size a n -- ; -- a ) forthentry literal, c: getmem m: ;; ;
 : 3dup >r 2dup r@ -rot r> ;
 : arraytype ( nk .. .. n1 n0 k ) over wsparse 3dup 3dup 3dup compile+ compile- compilecell
   rot drop 2dup >r >r compile[] r> r> 3dup compilearray compilesize ;
 ' arraytype
;loc alias arraytype

loc:
 var adr
 : _cmp ( a n1 a n2 -- result ) vector ." no comparison function defined!!" cr ; | target: cmp(a[i],a[i+n])=true
 : _swap_func ( a n1 a n2 -- ) vector ." no swap function defined!!" cr ;
 : cmp ( n1 n2 -- result ) 2dup <> if adr @ dup >r -rot r> swap _cmp else 2drop false then ;
 : swap_func ( n1 n2 -- ) 2dup <> if adr @ dup >r -rot r> swap _swap_func else 2drop then ;
 : avg ( n1 n2 -- average ) + 1 >> ;
 : mid2begin ( n1 n2 -- ) over avg swap_func ;
 : arrange ( n1 n2 -- nmid ) 2dup mid2begin over tuck tuck - for ( i n1 j ) 1+
           2dup cmp if rot 1+ 2dup swap_func -rot then next drop over swap_func ;
 : sort ( n1 n2 -- ) 2dup < if 2dup arrange tuck 1+ swap sort 1- sort else 2drop then ;
 : quicksort ( a n swap_proc cmp_proc -- ) ['] _cmp vectorize ['] _swap_func vectorize swap adr ! 1- 0 swap sort ;
 ' quicksort
;loc alias quicksort ( a n swap_proc cmp_proc -- )
