| runtime library of primitive functions for QuickForth

| basic data transfer operations

macro
: nip $04c683 3, ; | add esi, 4
| : dup $fc4689 3, $04ee83 3, ; | mov [esi-4], eax; sub esi, 4
: dup $04ee83 3, $0689 2, ; | sub esi, 4; mov [esi], eax
: drop $068b 2, m: nip ; |  mov eax, [esi]; nip
| : drop $068b 2, $04768d 3, ; | mov eax, [esi]; lea esi, [esi+4] - slow!
| : drop $ad 1, ; | lodsd - slow!!
: swap $0687 2, ; | xchg eax, [esi]
: rot $0687 2, $044687 3, ; | xchg eax, [esi]; xchg eax, [esi+4]
: -rot $044687 3, $0687 2, ; | xchg eax, [esi+4]; xchg eax, [esi]
: over m: dup $04468b 3, ; | dup; mov eax, [esi+4]
: tuck $168b 2, $0689 2, $04ee83 3, $1689 2, ; | mov edx, [esi]; mov [esi], eax; sub esi, 4; mov [esi], edx 
: 2drop $04468b 3, $08c683 3, ; | mov eax, [esi+4]; add esi, 8
: 2dup $fc4689 3, $168b 2, $08ee83 3, $1689 2, ; | mov [esi-4], eax; mov edx, [esi]; sub esi, 8; mov [esi], edx 
: 2swap $044687 3, $168b 2, $085687 3, $1689 2, ; | xchg [esi+4], eax; mov edx, [esi]; xchg edx, [esi+8]; mov [esi], edx 
: @ $008b 2, ; | mov eax, [eax]
: ! $c289 2, $068b 2, $0289 2, m: 2drop ; | mov edx, eax; mov eax, [esi]; mov [edx], eax; 2drop
: w@ $c289 2, $c031 2, $028b66 3, ; | mov edx, eax; xor eax, eax; mov ax, [edx]
: w! $c289 2, $068b 2, $028966 3, m: 2drop ; | mov edx, eax; mov eax, [esi]; mov [edx], ax; 2drop
: c@ $c289 2, $c031 2, $028a 2, ; | mov edx, eax; xor eax, eax; mov al, [edx]
: c! $c289 2, $068b 2, $0288 2, m: 2drop ; | mov edx, eax; mov eax, [esi]; mov [edx], al; 2drop
: p@ $c289 2, $028b 2, m: dup $04428b 3, ; | mov edx, eax; mov eax, [edx]; dup; mov eax, [edx+4]
: p! $c289 2, $068b 2, $044289 3, $04468b 3, $0289 2, $08468b 3, $0cc683 3, ;
 | mov edx, eax; mov eax, [esi]; mov [edx+4], eax; mov eax, [esi+4]; mov [edx], eax; mov eax, [esi+8]; add esi, 12
: 2@ $c289 2, $04428b 3, m: dup $028b 2, ; | mov edx, eax; mov eax, [edx+4]; dup; mov eax, [edx]
: 2! $c289 2, $068b 2, $0289 2, $04468b 3, $044289 3, $08468b 3, $0cc683 3, ;
 | mov edx, eax; mov eax, [esi]; mov [edx], eax; mov eax, [esi+4]; mov [edx+4], eax; mov eax, [esi+8]; add esi, 12
: >r $50 1, m: drop ; | push eax; drop
: r> m: dup $58 1, ; | dup; pop eax
: r@ m: dup $58 1, $50 1, ; | dup; pop eax; push eax
: rdrop $5a 1, ; | pop edx

forth
: nip nip ;
: dup dup ;
: drop drop ;
: swap swap ;
: rot rot ;
: -rot -rot ;
: over over ;
: tuck tuck ;
: 2drop 2drop ;
: 2dup 2dup ;
: 2swap 2swap ;
: @ @ ;
: ! ! ;
: w@ w@ ;
: w! w! ;
: c@ c@ ;
: c! c! ;
: p@ p@ ;
: p! p! ;
: 2@ 2@ ;
: 2! 2! ;
: >r >r ;
: r> r> ;
: r@ r@ ;
: rdrop rdrop ;

| arithmetical and logical operations

macro
: setfalse $f9 1, ; | stc
: settrue $f8 1, ;  | clc
: not $d0f7 2, ; | not eax
: false m: dup $c031 2, ; | dup; xor eax, eax;
: 0 m: false ;
: true m: false m: not ; | false; not
: and $0623 2, m: nip ; | and eax, [esi]; nip
: or $060b 2, m: nip ;  | or eax, [esi]; nip
: xor $0633 2, m: nip ; | xor eax, [esi]; nip
: >> $c189 2, m: drop $e8d3 2, ; | mov ecx, eax; drop; shr eax, cl
: << $c189 2, m: drop $e0d3 2, ; | mov ecx, eax; drop; shl eax, cl
: 1+ $40 1, ; | inc eax
: 1- $48 1, ; | dec eax
: negate $d8f7 2, ; | neg eax
: abs $c009 2, $027f 2, $d8f7 2, ; | or eax, eax; jg end; neg eax
: + $0603 2, m: nip ; | add eax, [esi]; nip
: * $26f7 2, m: nip ; | imul eax, [esi]; nip
: - $c289 2, m: drop $d029 2,  ; | mov edx, eax; drop; sub eax, edx
: /mod ( n -- mod div ) $c189 2, $068b 2, $99 1, $f9f7 2, $1689 2, ; | mov ecx, eax; mov eax, [esi]; cdq; idiv ecx; mov [esi], edx
: / $c189 2, m: drop $99 1, $f9f7 2, ; | mov ecx, eax; drop; cdq; idiv ecx; 
: mod m: / $d089 2, ; | /; mov eax, edx;
: cells $02e0c1 3, ; | shl eax, 2
: cell+ $04c083 3, ; | add eax, 4
: cell- $04e883 3, ; | sub eax, 4
: word+ $02c083 3, ; | add eax, 2
: word- $02e883 3, ; | sub eax, 2

forth
: setfalse setfalse ;
: settrue settrue ;
: not not ;
: false false ;
: 0 0 ;
: true true ;
: and and ;
: or or ;
: xor xor ;
: >> >> ;
: << << ;
: 1+ 1+ ;
: 1- 1- ;
: negate negate ;
: abs abs ;
: + + ;
: * * ;
: - - ;
: /mod /mod ;
: / / ;
: mod mod ;
: cells cells ;
: cell+ cell+ ;
: cell- cell- ;
: word+ word+ ;
: word- word- ;
