| windows-specific runtime library for QuickForth

| memory management

forth
loc:
 from kernel32.dll
  3 import HeapCreate
  1 import HeapDestroy
  3 import HeapAlloc
  3 import HeapFree
  4 import HeapReAlloc
  2 import HeapCompact
  3 import HeapSize
 1 const HEAP_NO_SERIALIZE
 4 const HEAP_GENERATE_EXCEPTIONS
 8 const HEAP_ZERO_MEMORY
 var heap
 HEAP_NO_SERIALIZE 0 0 HeapCreate heap !
 : compactmem heap @ HEAP_NO_SERIALIZE HeapCompact ;
 : getmem heap @ swap HEAP_NO_SERIALIZE HEAP_ZERO_MEMORY or swap HeapAlloc ;
 : freemem heap @ swap HEAP_NO_SERIALIZE swap HeapFree compactmem drop ;
 : resizemem heap @ -rot HEAP_NO_SERIALIZE HEAP_ZERO_MEMORY or -rot HeapReAlloc ;
 : memsize heap @ swap HEAP_NO_SERIALIZE swap HeapSize ;
 ' memsize ' getmem ' resizemem ' freemem
;loc
 alias freemem ( p -- result )
 alias resizemem ( p n -- new_p ) | page size = 4k !
 alias getmem ( n -- p ) | page size = 4k !
 alias memsize ( p -- n )

: getmemforcode ( n -- ) getmem h0 ! ;
: getmemfordictionary ( n -- ) getmem dictionary_top ! ;
: getmemforstack ( n -- ) dup getmem + setstackpointer ;

| file i/o

loc:
 from kernel32.dll
  7 import CreateFileA
  1 import DeleteFileA
  2 import MoveFileA
  5 import ReadFile
  5 import WriteFile
  4 import SetFilePointer
  1 import CloseHandle
  2 import GetFileSize
  
  2 import FindFirstFileA
  2 import FindNextFileA
  1 import SetCurrentDirectoryA
  
 $80000000 const GENERIC_READ
 $40000000 const GENERIC_WRITE
 1  const CREATE_NEW
 2  const CREATE_ALWAYS
 3  const OPEN_EXISTING
 4  const OPEN_ALWAYS
 5  const TRUNCATE_EXISTING
 0  const FILE_BEGIN
 1  const FILE_CURRENT
 2  const FILE_END
 -1 const INVALID_HANDLE_VALUE

 var _pad
 : closefile ( hfile -- ) CloseHandle drop ;
 : openfile ( filename accessmode createmode -- hfile ) 2swap zt -rot 0 0 rot 0 0 CreateFileA ;
| : openfileread ( filename -- hfile ) GENERIC_READ OPEN_EXISTING openfile ;
 : openfileread ( filename -- hfile ) 2dup GENERIC_READ OPEN_EXISTING openfile
   dup >r -1 = if ." WARNING: file " type ."  not found!" cr else 2drop then r> ;
 : openfilewrite ( filename -- hfile ) GENERIC_WRITE CREATE_ALWAYS openfile ;
 : openfilereadwrite ( filename -- hfile ) GENERIC_READ GENERIC_WRITE or OPEN_ALWAYS openfile ;
 : deletefile ( filename -- result ) zt DeleteFileA ;
 : movefile ( oldname newname -- result ) zt -rot zt swap MoveFileA ;
 : fileexists ( filename -- result ) 0 OPEN_EXISTING openfile dup closefile true <> ;
 : seekfilecurrent ( hfile distance -- result ) 0 FILE_CURRENT SetFilePointer ;
 : seekfilebegin ( hfile distance -- result ) 0 FILE_BEGIN SetFilePointer ;
 : seekfileend ( hfile distance -- result ) 0 FILE_END SetFilePointer ;
 : readfile ( hfile a n -- bytes result? ) >r _pad -rot r> _pad 0 ReadFile swap @ swap ;
 : writefile ( hfile a n -- bytes result? ) >r _pad -rot r> _pad 0 WriteFile swap @ swap ;
 : filesize ( hfile -- n ) pad GetFileSize ;
 : filesizeqword ( hfile -- lo hi ) _pad tuck GetFileSize swap @ swap ;
 
| struc FINDDATA
|  {
|    .dwFileAttributes   dd ?
|    .ftCreationTime     FILETIME
|    .ftLastAccessTime   FILETIME
|    .ftLastWriteTime    FILETIME
|    .nFileSizeHigh      dd ?
|    .nFileSizeLow       dd ?
|    .dwReserved0        dd ?
|    .dwReserved1        dd ?
|    .cFileName	       rb 260
|    .cAlternateFileName rb 14
|  }
| struct FINDDATA

 11 cells 260 14 + + array finddata
 : findfirstfile ( filename -- hfindfile ) zt finddata FindFirstFileA ;
 : findnextfile ( hfindfile -- result ) finddata FindNextFileA ;
 : changedirectory ( dir -- result ) zt SetCurrentDirectoryA ;
 : foundfilename ( -- a n ) finddata 11 cells + dup begin dup c@ 0 <> while 1+ end over - ;
 
 ' findfirstfile ' findnextfile ' changedirectory ' foundfilename
 ' seekfileend ' seekfilebegin ' seekfilecurrent ' fileexists
 ' movefile ' deletefile ' openfilereadwrite ' openfilewrite ' openfileread
 ' closefile ' readfile ' writefile ' filesize ' filesizeqword
;loc alias filesizeqword alias filesize alias writefile alias readfile alias closefile
     alias openfileread alias openfilewrite alias openfilereadwrite alias deletefile alias movefile
     alias fileexists alias seekfilecurrent alias seekfilebegin alias seekfileend
     alias foundfilename alias changedirectory alias findnextfile alias findfirstfile

: openfileappend ( filename -- hfile ) openfilereadwrite dup 0 seekfileend drop ;
: loadfile ( filename -- a n ) openfileread dup dup filesize dup
  getmem dup >r swap readfile drop swap closefile r> swap ;
: savefile ( filename a n -- bytes result ) 2swap openfilewrite dup >r -rot writefile r> closefile ;
: appendfile ( filename a n -- bytes result ) 2swap openfileappend dup >r -rot writefile r> closefile ;
