| REM: RetroEditor for Mortals
|
| This version is for RetroForth/Windows
|
| RetroForth has had a line-oriented editor called RED
| (short for RetroEditor) for several years. In 8.x, RED is
| included with the RetroForth system.
|
| Numerous people have commented that RED is a bit difficult
| to learn to use. REM is my attempt to leverage parts of RED
| in an easier to learn editor.
|
| REM is modal. You start off in "command mode", which lets
| you navigate through the blocks, move the cursor to a
| specific line+column, and reload or save the current block
| file.
|
| The other mode is the "edit" mode, which lets you enter new
| code into a block. Press the escape key to switch modes. To
| aid new users, the current mode is displayed under the block
| view.
|
| In command mode the following keys have actions bound to them:
|
| +-- KEY --+--- ACTION -----------------------------------+
| |    i    | Move the cursor up                           |
| +---------+----------------------------------------------+
| |    k    | Move the cursor down                         |
| +---------+----------------------------------------------+
| |    j    | Move the cursor left                         |
| +---------+----------------------------------------------+
| |    l    | Move the cursor right                        |
| +---------+----------------------------------------------+
| |    J    | Go to the previous block                     |
| +---------+----------------------------------------------+
| |    L    | Go to the next block                         |
| +---------+----------------------------------------------+
| |    o    | Open (reload) the current blockfile          |
| +---------+----------------------------------------------+
| |    s    | Save the current blockfile                   |
| +---------+----------------------------------------------+
| |    q    | Quit REM and go back to RetroForth           |
| +---------+----------------------------------------------+
| |    \    | Evaluate the current blockfile               |
| +---------+----------------------------------------------+
|
| Well, that about sums this all up. Give it a try, report bugs,
| and happy coding!

loc:
  from kernel32.dll
  2 import SetConsoleCursorPosition
  1 import GetStdHandle
  -11 GetStdHandle constant handle
  here ] 16 << + handle swap SetConsoleCursorPosition drop ;
;loc alias xy


loc:
 from kernel32.dll
   4 import ReadConsoleInputA
   1 import GetStdHandle
 -10 GetStdHandle constant stdin
     variable buffer
 : ekey stdin here 1 buffer ReadConsoleInputA drop
   here @ 1 <>if ekey ;; then
   here cell+ @ 1 =if ekey ;; then
   here 14 + @ $0000ffff and ;
 ' ekey
;loc alias ekey


variable mode
variable line
variable column

create currKey '$ 1, '$ 1, 'c 1, 0 1,

: $$ci 1 line -! ;      : $$ck 1 line +! ;
: $$cj 1 column -! ;    : $$cl 1 column +! ;
: $$cI 0 column ! ;     : $$cK $$cI $$ck ;
: $$cJ p ;              : $$cL n ;
: $$co r ;              : $$cs w ;
: $$c\ \ ;              : $$cq r> drop clear v ;

loc:
  : mode0  mode @ 0 ;
  : >buffer line @ (line) column @ + ;
  : enter  mode @ 1 =if >buffer c! $$cl then ;
  : setup  currKey 3 + c! currKey 4 ;
  : match  mode0 =if setup find ?if ;; then 2drop 0 then false ;
  : .mode  mode0 =if ." COMMAND" ;; then ." ENTRY  " ;
  : cursor .mode column @ 2 + line @ 1+ xy ;
  : screen home v cursor ;
  : isEntry mode @ 1 =if true ;; then false ;
  : change isEntry ?if 0 mode ! ;; then 1 mode ! ;
  : mode?  dup 27 =if change drop screen ekey then ;
  : ed screen ekey mode? match ?if execute ed ;; then enter ed ;
  here ] clear ed ;
;loc alias rem
new
