; -----------------------------------------------------------------------------
; __          ___       ____ ___
; \ \        / (_)     |___ \__ \   RetroForth for Windows
;  \ \  /\  / / _ _ __   __) | ) |  http://www.retroforth.org
;   \ \/  \/ / | | '_ \ |__ < / /
;    \  /\  /  | | | | |___) / /_
;     \/  \/   |_|_| |_|____/____|
; -----------------------------------------------------------------------------

format PE console
stack 16000
entry start

include "macros.fasm"
include "windows-include/win32a.inc"

section ".code" code readable writeable executable
start:
	pusha
	invoke GetModuleHandle, 0
	mov [hinstance], eax

	invoke GetStdHandle, STD_INPUT_HANDLE
	mov [StdIn], eax
	invoke SetConsoleMode, eax, 5

	invoke GetStdHandle, STD_OUTPUT_HANDLE
	mov [StdOut], eax

	invoke SetConsoleTitle, "RetroForth"
	popa

	call init_retroforth
	jmp boot
;---------------------------------------------------------------------
code 'bye', windows_bye
	vector
	invoke ExitProcess,0
ret

sys_emit:
	pusha
	mov [emit_buffer], eax  ; keep it safe
	invoke WriteFile, [StdOut], emit_buffer, 1, written_buffer, 0
	popa
	drop
	ret

sys_key:
	dup
	pusha
	invoke ReadFile, [StdIn], emit_buffer, 1, written_buffer, 0
	popa
	mov eax, [emit_buffer]
	cmp eax, 13
	jnz .done
	drop
	jmp sys_key
.done:	next

sys_type:
	mov ebx, [esi]
	pusha
	invoke WriteFile, [StdOut], ebx, eax, written_buffer, 0
	popa
	drop
	drop
next

old_esp  dd 0
lib_addr dd 0
code 'from', _from
	upsh 32
	call parse
	embed 'zt'
	upop edx
	pusha
	invoke LoadLibrary, edx
	mov dword [lib_addr], eax
	popa
next
code 'import', _import
	pusha
	upsh 32
	call parse
	embed '2dup entry zt'
	upop edx
	invoke GetProcAddress,[lib_addr],edx
	cmp eax, 0
	jz import_error
	call literal
	popa
	call literal
	upsh _invoke
	call compile
	jmp ssemi

import_error:
        popa
        drop
        upsh error_message
        upsh 43
        call type
        embed 'last @ 13 + dup 1- c@ type cr last @ @ last !'
        ret
error_message db 'Error: Attempt to import unknown function: '


_invoke:
	mov dword [old_esp], esp
	swap
	upop [faddr]		; Get the function address
	upop ecx
	cmp ecx, 0
	jz .run
.chain: push eax
	drop
	loop .chain
.run:	upsh [faddr]		; Restore the function address
	call dword eax
	mov esp, dword [old_esp]
next
faddr dd 0
;---------------------------------------------------------------------
hinstance rd 1
StdIn rd 1
StdOut rd 1
emit_buffer rd 1
written_buffer rd 1
tempX rd 1
;---------------------------------------------------------------------
; windows-specific linkage stuff:
data import

  library kernel,'KERNEL32.DLL'

  import kernel,\
	 OpenFile, 'OpenFile',\
	 GetModuleHandle,'GetModuleHandleA',\
	 ExitProcess,'ExitProcess',\
	 GetStdHandle, 'GetStdHandle',\
	 WriteFile, 'WriteFile',\
	 ReadFile, 'ReadFile',\
	 SetConsoleCursorPosition,'SetConsoleCursorPosition',\
	 SetConsoleTextAttribute,'SetConsoleTextAttribute',\
	 SetConsoleMode, 'SetConsoleMode',\
	 SetConsoleTitle, 'SetConsoleTitleA',\
	 GetConsoleScreenInfo,'GetConsoleScreenBufferInfo',\
	 CreateFile, 'CreateFileA',\
	 GetLastError,'GetLastError',\
	 CloseHandle,'CloseHandle',\
	 CreateConsoleScreenBuffer,'CreateConsoleScreenBuffer',\
	 SetConsoleActiveScreenBuffer,'SetConsoleActiveScreenBuffer',\
	 LoadLibrary,'LoadLibraryA',\
	 GetProcAddress,'GetProcAddress'
end data

include "core.asm"
fdata rb 1024 
