DROP IF EXISTS TABLE sta_news;
DROP IF EXISTS TABLE sta_categories;
DROP IF EXISTS TABLE sta_comments;
DROP TABLE sta_articles;

CREATE TABLE sta_users (
	id int unsigned auto_increment not null primary key, 
	name varchar(32) not null,
	login varchar(32) not null,
	password varchar(48) not null,
	mail varchar(64),
	icq int(16),
	gid tinyint default '1',
	joined int(16),
	
	index(`name`),
	index(`login`)
);

ALTER TABLE sta_users ADD COLUMN skin varchar(16) default 'classic';

CREATE TABLE sta_news (
	id int unsigned auto_increment not null primary key,
	name varchar(32),
	nalias varchar(32),
	description tinytext,
	full_text text,
	added int(12),
	
	index(`nalias`),
	index(`added`)
);

CREATE TABLE sta_categories (
	id int unsigned auto_increment not null primary key,
	cid int unsigned not null,
	oid int unsigned,
	name varchar(32),
	calias varchar(32),
	description text,
	logo varchar(32),
	
	index(`oid`),
	index(`calias`)
);

CREATE TABLE sta_comments (
	id int unsigned not null auto_increment primary key,
	uid mediumint unsigned not null,
	aid mediumint unsigned not null,
	comment text,
	added int(12),

	index(`aid`)
);

CREATE TABLE sta_articles (
	id mediumint unsigned not null auto_increment primary key,
	cid mediumint not null,
	name varchar(32),
	coheader varchar(128),
	aalias varchar(32),
	author varchar(48),
	data text,
	voteblock tinyint,
	commentblock tinyint,
	viewed int(6) default '0',
	added int(12),

	index(`cid`),
	index(`added`)
);

CREATE TABLE sta_article_votes (
	id int unsigned not null auto_increment primary key,
	aid int unsigned not null,
	uid int unsigned not null,
	vote int(2),
	
	index(`aid`)
);

ALTER TABLE sta_articles ADD COLUMN index_txt text;

CREATE TABLE sta_global_polls (
	id int unsigned not null auto_increment primary key,
	question varchar(255),
	palias varchar(64),
	polldata text,
	added int(12),
	period int(12),
	
	index(`question`),
	index(`added`)
);

CREATE TABLE sta_global_votes (
	id int unsigned not null auto_increment primary key,
	pid int unsigned not null,
	uid int unsigned not null,
	vote int(2),
	
	index(`pid`)
);

CREATE TABLE sta_file_categories (
	id int unsigned not null auto_increment primary key,
	name varchar(128),
	dir varchar(64),
	description text
);

CREATE TABLE sta_files (
	id int unsigned not null auto_increment primary key,
	cid int unsigned not null,
	name varchar(128),
	filepath varchar(255),
	mimetype varchar(255),
	
	description text,
	poster varchar(32),
	downloaded int(8) unsigned,
	added int(12),
	
	index(`cid`)
);

/*CREATE TABLE sta_robots (
	id int unsigned not null auto_increment primary key,
	ip1 varchar(4),
	ip2 varchar(4),
	ip3 varchar(4),
	ip4 varchar(4),
	
	index(`ip1`),
	index(`ip2`),
	index(`ip3`),
	index(`ip4`)
);*/

