<?

require_once('./db.php');

$DB = new database;
$DB->connect();

$PICGEN = new pic_generator();

class pic_generator {
	function pic_generator() {
		if(!isset($_GET['act'])) $this->error("Error!");
		
		if($_GET['act']=='rf') $this->article_rate_full();
		if($_GET['act']=='tn') $this->thumbnail();
	}
	
	function error($str) {
		header('Content-type: image/png');
	
		$err = ImageCreate(256,64);
		$white = ImageColorAllocate($err, 255, 255, 255);
		$red = ImageColorAllocate($err, 255, 0, 0);
		ImageString($err, 5, 2, 2, $str, $red);
		
		ImagePNG($err);
		
		ImageDestroy($err);
	}

	function article_rate_full() {
		global $DB;
	
		if(!isset($_GET['id'])) $this->error("Error ID!");
	
		header('Content-type: image/png');
	
		$id = $_GET['id'];
	
		$diagram = ImageCreate(192,128);
		
		$white = ImageColorAllocate($diagram, 255,255,255);
		$black = ImageColorAllocate($diagram, 0,0,0);
		$blue = ImageColorAllocate($diagram, 128,128,255);
		
		$r1 = $DB->fast_query("SELECT count(*) AS num FROM sta_article_votes WHERE aid=$id AND vote=1", 'num');
		$r2 = $DB->fast_query("SELECT count(*) AS num FROM sta_article_votes WHERE aid=$id AND vote=2", 'num');
		$r3 = $DB->fast_query("SELECT count(*) AS num FROM sta_article_votes WHERE aid=$id AND vote=3", 'num');
		$r4 = $DB->fast_query("SELECT count(*) AS num FROM sta_article_votes WHERE aid=$id AND vote=4", 'num');
		$r5 = $DB->fast_query("SELECT count(*) AS num FROM sta_article_votes WHERE aid=$id AND vote=5", 'num');
		
		$maximum = max($r1, max($r2, max($r3, max($r4, $r5))));
		
		$maximum = $maximum - $maximum%5 + 5;
		
		ImageLine($diagram, 24, 114, 191, 114, $black);
		ImageLine($diagram, 24, 0, 24, 114, $black);
		
		ImageString($diagram, 1, 2, 2, strval($maximum), $black);
		ImageString($diagram, 1, 2, 115, '0', $black);
		ImageString($diagram, 1, 48, 115, '1', $black);
		ImageString($diagram, 1, 80, 115, '2', $black);
		ImageString($diagram, 1, 112, 115, '3', $black);
		ImageString($diagram, 1, 144,  115, '4', $black);
		ImageString($diagram, 1, 176, 115, '5', $black);
		
		ImageFilledRectangle($diagram, 36,114-$r1*114/$maximum,60,114, $blue);
		ImageFilledRectangle($diagram, 68,114-$r2*114/$maximum,92,114, $blue);
		ImageFilledRectangle($diagram, 100,114-$r3*114/$maximum,124,114, $blue);
		ImageFilledRectangle($diagram, 132,114-$r4*114/$maximum,156,114, $blue);
		ImageFilledRectangle($diagram, 164,114-$r5*114/$maximum,188,114, $blue);
		
		ImageString($diagram, 1, 48, 100, $r1, $white);
		ImageString($diagram, 1, 80, 100, $r2, $white);
		ImageString($diagram, 1, 112, 100, $r3, $white);
		ImageString($diagram, 1, 144, 100, $r4, $white);
		ImageString($diagram, 1, 176, 100, $r5, $white);
		
		ImagePNG($diagram);
		
		ImageDestroy($diagram);
	}

        function thumbnail() {
		global $DB,$INFO;
		
		if(!isset($_GET['id'])) $this->error("Internal error!");
		
		header('Content-type: image/png');
	
		$id = $_GET['id'];
	
		$DB->query('SELECT * FROM sta_files WHERE id='.$id);
		
		if($DB->successful==0) $this->error("File doesn't exist!");
		
		$thumbbase = "";
		$thumb = "";
		
		if(eregi('[A-Za-z0-9]\.(jpeg|jpg)', $DB->row['filepath']))	 {
			$thumbbase = ImageCreateFromJPEG($INFO['uploadsdir'].'/'.$DB->row['filepath']);
		}
		else if(eregi('[A-Za-z0-9]\.(png)', $DB->row['filepath']))	 {
			$thumbbase = ImageCreateFromPNG($INFO['uploadsdir'].'/'.$DB->row['filepath']);
		}
		else if(eregi('[A-Za-z0-9]\.(gif)', $DB->row['filepath']))	 {
			$thumbbase = ImageCreateFromGIF($INFO['uploadsdir'].'/'.$DB->row['filepath']);
		}
		else {
			$this->error("Unsupported source!");
		}
		
		$width = ImageSX($thumbbase);
		$height = ImageSY($thumbbase);
		
		$k = max($width/64, $height/48);
		
		$new_width = intval($width / $k);
		$new_height = intval($height / $k);
		
		//echo $new_height;
		
		$thumb = imagecreatetruecolor ($new_width, $new_height);
		
		imagecopyresampled($thumb, $thumbbase, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
		
		ImagePNG($thumb);
		
		ImageDestroy($thumb);
		ImageDestroy($thumbbase);
	}
};

?>
